﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using Microsoft.WindowsMobile.PocketOutlook;
using Microsoft.WindowsMobile.PocketOutlook.MessageInterception;
using Microsoft.WindowsMobile.Telephony;

namespace PrzechwytywanieSMS
{
    public partial class Form1 : Form
    {
        MessageInterceptor przechwytywanieSms;

        public Form1()
        {
            InitializeComponent();

            ustawPrzechwytywanieSms(out przechwytywanieSms);
        }

        void ustawPrzechwytywanieSms(out MessageInterceptor przechwytywanieSms)
        {
            przechwytywanieSms = new MessageInterceptor(InterceptionAction.NotifyAndDelete);
            przechwytywanieSms.MessageCondition = new MessageCondition(MessageProperty.Body,
                MessagePropertyComparisonType.StartsWith, "cmd:", true);
            przechwytywanieSms.MessageReceived +=
                new MessageInterceptorEventHandler(przechwytywanieSms_MessageReceived);
        }

        void przechwytywanieSms_MessageReceived(object sender, MessageInterceptorEventArgs e)
        {
            string plikExe=System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase;
            System.Diagnostics.Process.Start(plikExe, "");  //przywolanie aplikacji          

            SmsMessage sms = (SmsMessage)e.Message;
            listBox1.Items.Add(sms.From.Name + ": " + sms.Body);            
            if (sms.Body.StartsWith("cmd:callback"))
            {
                string nt = sms.From.Address; //opis kontaktu z numerem telefonu
                if (nt.Contains(">"))
                {
                    nt = nt.Remove(0, nt.LastIndexOf("<") + 1);
                    nt = nt.Remove(nt.IndexOf(">"), nt.Length - nt.IndexOf(">"));
                }
                listBox1.Items.Add("   Oddzwaniam na numer " + nt);
                
                new Phone().Talk(nt);
            }
            else listBox1.Items.Add("   Polecenie nierozpoznane");
        }

        private void menuItem1_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void Form1_Closed(object sender, EventArgs e)
        {
            przechwytywanieSms.MessageReceived -= przechwytywanieSms_MessageReceived;
            przechwytywanieSms.Dispose();
        }
    }
}